### Name: import/export
### Title: Read and write gene sets from Broad or GMT formats
### Aliases: io getBroadSets asBroadUri toBroadXML toGmt getGmt
### Keywords: manip

### ** Examples

## 'fl' could also be a URI
fl <- system.file("extdata", "Broad.xml", package="GSEABase")
gss <- getBroadSets(fl) # GeneSetCollection of 2 sets
names(gss)
gss[[1]]

## Not run: 
##D ## Download 'msigdb_v2.5.xml' or 'c3.all.v2.5.symbols.gmt' from the
##D ## Broad, http://www.broad.mit.edu/gsea/downloads.jsp#msigdb, then
##D gsc <- getBroadSets("/path/to/msigdb_v.2.5.xml")
##D types <- sapply(gsc, function(elt) bcCategory(collectionType(elt)))
##D c3gsc1 <- gsc[types == "c3"]
##D c3gsc2 <- getGmt("/path/to/c3.all.v2.5.symbols.gmt",
##D                  collectionType=BroadCollection(category="c3"),
##D                  geneIdType=SymbolIdentifier())
## End(Not run)

fl <- tempfile()
toBroadXML(gss[[1]], con=fl)
noquote(readLines(fl))
unlink(fl)

## Not run: 
##D toBroadXML(gss[[1]]) # character vector
## End(Not run)

fl <- tempfile()
toGmt(gss, fl)
getGmt(fl)
unlink(fl)



