### Name: GeneIdentifierType
### Title: Gene Identifier Class Constructors
### Aliases: GeneIdentifierType NullIdentifier EnzymeIdentifier
###   ENSEMBLIdentifier GenenameIdentifier RefseqIdentifier
###   SymbolIdentifier UnigeneIdentifier EntrezIdentifier
###   AnnotationIdentifier
### Keywords: manip

### ** Examples

NullIdentifier()

data(sample.ExpressionSet)
gs1 <- GeneSet(sample.ExpressionSet[100:109],
               setName="sample1", setIdentifier="100")
geneIdType(gs1) # AnnotationIdentifier

geneIds <- featureNames(sample.ExpressionSet)[100:109]
gs2 <- GeneSet(geneIds=geneIds,
               setName="sample1", setIdentifier="101")
geneIdType(gs2) # NullIdentifier, since no info about genes provided

## Convert...
ai <- AnnotationIdentifier(annotation(sample.ExpressionSet))
geneIdType(gs2) <- ai
geneIdType(gs2)
## ...or provide more explicit construction
gs3 <- GeneSet(geneIds=geneIds, type=ai,
               setName="sample1", setIdentifier="102")



