### Name: tile
### Title: Tiling/untiling images
### Aliases: tile untile
### Keywords: manip

### ** Examples

  ## make a set of blurred Lenas
  lena = readImage(system.file("images", "lena-color.png", package="EBImage"))
  x = resize(lena, 128, 128)
  xt = list()
  for (t in seq(0.1, 5, len=9)) xt=c(xt, list(blur(x, s=t)))
  xt = combine(xt)
  if (interactive()) display(xt, title='Blurred Lenas')

  ## tile
  xt = tile(xt, 3)
  if (interactive()) display(xt, title='Tiled Lenas')

  ## untile
  xu = untile(lena, c(3, 3))
  if (interactive()) display(xu, title='Lena blocks')



