### Name: Image
### Title: Image class
### Aliases: Image Image-class Grayscale TrueColor Color is.Image as.Image
###   print.Image median.Image quantile.Image colorMode colorMode<-
###   getNumberOfFrames imageData imageData<- colormode
###   Ops,Image,Image-method Ops,numeric,Image-method
###   Ops,Image,numeric-method [,Image,ANY,ANY,ANY-method [,Image-method
###   show,Image-method image,Image-method hist,Image-method


### ** Examples

  s1 = exp(12i*pi*seq(-1, 1, length=300)^2)
  y = Image(outer(Im(s1), Re(s1)))
  if (interactive()) display(normalize(y))

  x = Image(rnorm(300*300*3),dim=c(300,300,3), colormode='Color')
  if (interactive()) display(x) 

  w = matrix(seq(0, 1, len=300), nc=300, nr=300)
  m = abind(w, t(w), along=3)
  z = Image(m, colormode='Color')
  if (interactive()) display(normalize(z))

  y = Image(c('red', 'violet', '#ff51a5', 'yellow'), dim=c(71, 71))
  if (interactive()) display(y)

  ## colorMode example
  x = readImage(system.file('images', 'nuclei.tif', package='EBImage'))
  x = x[,,1:3]
  if (interactive()) display(x, title='Cell nuclei')
  colorMode(x)=Color
  if (interactive()) display(x, title='Cell nuclei in RGB')



