### Name: DFP-package
### Title: DFP Package Overview
### Aliases: DFP-package DFP
### Keywords: package

### ** Examples

#########################################
############ Get sample data ############
#########################################
library(DFP)
data(rmadataset)

#########################################
# Filter the most representative genes  #
#########################################
res <- discriminantFuzzyPattern(rmadataset)

#########################################
###### Different result displays ########
#########################################
plotMembershipFunctions(rmadataset, res$membership.functions, featureNames(rmadataset)[1:2])
showDiscreteValues(res$discrete.values, featureNames(rmadataset)[1:10], c("healthy", "AML-inv"))
showFuzzyPatterns(res$fuzzy.patterns, "healthy")[21:50]
plotDiscriminantFuzzyPattern(res$discriminant.fuzzy.pattern)



