### Name: result2html
### Title: output differentially expressed genes to a HTML file
### Aliases: result2html
### Keywords: misc

### ** Examples

data(testData)
normaldata<-pre.process("rma",testData)
## Create design matrix
design<-make.design(pData(normaldata), "group")

## Create contrast matrix - Compare group "A" vs. "C"
contrast<-make.contrast(design, "A", "C")

## Identify differentially expressed gene by using LIMMA method
result<-regress(normaldata, design, contrast, "L")

## Select differentially expressed gene based on p <0.05 and 
## fold change >=log2(1.5)
select<-select.sig.gene(result, p.value=0.05, m.value=log2(1.5))

## Output differentially expressed gene to a example.html
result2html(annotation(normaldata), select, "example")



