###################################################
### chunk number 1: 
###################################################
library(ACME)


###################################################
### chunk number 2: 
###################################################
# Generate some random data
# 3 samples, 3 chromosomes
samps <- data.frame(SampleID=1:3,Sample=paste('Sample',1:3))
dat <- matrix(rnorm(90000),nc=3)
colnames(dat) <- 1:3 # we will use these to unambiguously name the samples
pos <- rep(seq(1,10000*100,100),3)
chrom <- rep(paste('chr',1:3,sep=""),each=10000)
annot <- data.frame(Chromosome=chrom,Location=pos)
a <- new('aGFF',data=dat,annotation=annot,samples=samps)


###################################################
### chunk number 3: 
###################################################
calc <- do.aGFF.calc(a,window=1000,thresh=0.95)


###################################################
### chunk number 4: 
###################################################
plot(calc,chrom='chr1',sample=1,xlim=c(10000,50000))


###################################################
### chunk number 5: 
###################################################
a


###################################################
### chunk number 6: 
###################################################
# write both calculated values and raw data
write.sgr(calc)
# OR write only calculated data
write.sgr(calc,raw=FALSE)


