### Name: stam.predict
### Title: Predict Classifications of New Data
### Aliases: stam.predict
### Keywords: classif

### ** Examples

## Not run: 
##D # load and prepare data
##D library(golubEsets)
##D data(Golub_Merge)
##D golubTest <- Golub_Merge[,39:72]
##D data(golubTrain.fit)
##D 
##D # compute predictions
##D golubTest.pred <- stam.predict(golubTrain.fit, golubTest, 
##D                                pData(golubTest)[,"ALL.AML"])
##D golubMerge.pred <- stam.predict(golubTrain.fit, Golub_Merge, 
##D                                 pData(Golub_Merge)[,"ALL.AML"], testset=39:72)
##D 
##D # further investigate
##D print(golubTest.pred)
##D plot(golubTest.pred)
## End(Not run)
## Not run: 
##D map <- image(golubMerge.pred, outfile="golubMerge")
##D cat("<HTML><BODY><MAP NAME='image_map'>", map, "</MAP>",
##D     "<IMG SRC='golubMerge_pred_img.png' USEMAP='#image_map'></BODY></HTML>\n", 
##D     file="pred_img.html")
##D browseURL(paste("file://", getwd(), "/pred_img.html", sep=""))
## End(Not run)


