### Name: DEResult
### Title: Class DEResult
### Aliases: class:DEResult DEResult DEResult-class statistic statistic<-
###   FC FC<- statisticDescription statisticDescription<- DEMethod
###   DEMethod<- pLikeValues topGenes topGeneIDs numberOfProbesets
###   numberOfGenes numberOfContrasts statistic,DEResult-method
###   statistic<-,DEResult,matrix-method FC,DEResult-method
###   FC<-,DEResult,matrix-method statisticDescription,DEResult-method
###   statisticDescription<-,DEResult,character-method
###   DEMethod,DEResult-method DEMethod<-,DEResult,character-method
###   pLikeValues,DEResult-method topGenes,DEResult-method
###   topGeneIDs,DEResult-method numberOfProbesets,DEResult-method
###   numberOfGenes,DEResult-method numberOfContrasts,DEResult-method
###   show,DEResult-method write.reslts,DEResult-method
### Keywords: classes

### ** Examples

## Create an example DEResult object
#       Next 4 lines commented out to save time in package checks, and saved version used
# if (require(affydata)) {
#       data(Dilution)
#       eset_mmgmos <- mmgmos(Dilution)
# }
data(eset_mmgmos)

#       Next line used so eset_mmgmos only has information about the liver factor
#       The scanner factor will thus be ignored, and the two arrays of each level
#       of the liver factor will be treated as replicates
pData(eset_mmgmos) <- pData(eset_mmgmos)[,1,drop=FALSE]

#       To save time we'll just use 100 probe sets for the example
eset_mmgmos_100 <- eset_mmgmos[1:100,]
eset_comb <- pumaComb(eset_mmgmos_100)

esetDE <- pumaDE(eset_comb)

## Use some of the methods
statisticDescription(esetDE)
DEMethod(esetDE)
numberOfProbesets(esetDE)
numberOfContrasts(esetDE)
topGenes(esetDE)
topGenes(esetDE, 3)
pLikeValues(esetDE)[topGenes(esetDE,3)]
topGeneIDs(esetDE, 3)
topGeneIDs(esetDE, 3, direction="down")

## save the expression results into files
write.reslts(esetDE, file="example")



