###################################################
### chunk number 1: startup
###################################################
library("matchprobes")
library("affy")
library("hgu95av2cdf")
library("hgu95av2probe")


###################################################
### chunk number 2: complementSeq
###################################################
example(complementSeq)


###################################################
### chunk number 3: reverseSeq
###################################################
example(reverseSeq)


###################################################
### chunk number 4: matchprobes
###################################################
pm    <- hgu95av2probe$sequence
pmdup <- c(pm, pm)
query <- hgu95av2probe$sequence[21:23]
m = matchprobes(query, pmdup)
unlist(m)


###################################################
### chunk number 5: basecontent
###################################################
bcpm <- basecontent(hgu95av2probe$sequence)
head(bcpm)


###################################################
### chunk number 6: hgu95av2dim
###################################################
nr = hgu95av2dim$NROW
nc = hgu95av2dim$NCOL


###################################################
### chunk number 7: 
###################################################
abseq = rep(as.character(NA), nr*nc)  

ipm = with(hgu95av2probe, xy2indices(x, y, nr=nr))

abseq[ipm] = pm
table(is.na(abseq))


###################################################
### chunk number 8: mismatchSeq
###################################################
mm <- complementSeq(pm, start=13, stop=13)
cat(pm[1], mm[1], sep="\n")

imm = with(hgu95av2probe, xy2indices(x, y+1, nr=nr))

abseq[imm] = mm
table(is.na(abseq))


###################################################
### chunk number 9: 
###################################################
library("hu6800cdf")
library("hu6800probe")


###################################################
### chunk number 10: loadcel
###################################################
f1 <- system.file("extdata", "118T1.cel", package="matchprobes")
f2 <- system.file("extdata", "CL2001032020AA.cel", package="matchprobes")
pd1 <- new("AnnotatedDataFrame", data=data.frame(fromFile=I(f1), row.names="f1"))
pd2 <- new("AnnotatedDataFrame", data=data.frame(fromFile=I(f2), row.names="f2"))
x1 <- read.affybatch(filenames=f1, compress=TRUE, phenoData=pd1)
x2 <- read.affybatch(filenames=f2, compress=TRUE, phenoData=pd2)


###################################################
### chunk number 11: docombine
###################################################
res <- combineAffyBatch(list(x1, x2), c("hu6800probe","hgu95av2probe"), newcdf="comb")


###################################################
### chunk number 12: dorma
###################################################
comb <- res$cdf
z    <- rma(res$dat)


###################################################
### chunk number 13: nrcp
###################################################
prs <- mget(ls(comb), comb, ifnotfound=NA)
nrprobes <- sapply(prs, function(x) nrow(x))
barplot(table(nrprobes), 
   xlab="number of probes per probeset", 
   ylab="frequency")


###################################################
### chunk number 14: scp
###################################################
png("matchprobes-scp.png", width=900, height=480)
par(mfrow=c(1,2))
plot(exprs(res$dat), main="after combine", 
  pch=".", asp=1, xlab="f1", ylab="f2", log="xy")
plot(exprs(z), main="after RMA",     
  pch=".", asp=1, xlab="f1", ylab="f2")
dev.off()


###################################################
### chunk number 15: bc
###################################################
bc = basecontent(abseq)
head(na.omit(bc))


###################################################
### chunk number 16: GC
###################################################
GC = ordered(bc[,"G"] + bc[,"C"])
colores = rainbow(nlevels(GC))


###################################################
### chunk number 17: bap
###################################################
barplot(table(GC), col=colores, xlab="GC", ylab="number")


###################################################
### chunk number 18: bxp
###################################################
boxplot(log2(exprs(x2)[,1]) ~ GC, outline=FALSE,
  col=colores, , xlab="GC", ylab=expression(log[2]~intensity))


###################################################
### chunk number 19: p2p
###################################################
png("matchprobes-p2p.png", width=900, height=480)
plot(exprs(x2)[ipm,1], exprs(x2)[imm,1], asp=1, pch=".", log="xy",
     xlab="PM", ylab="MM", col=colores[GC[ipm]])
abline(a=0, b=1, col="#404040", lty=3)
dev.off()


###################################################
### chunk number 20: makeprobepackage
###################################################
filename <- system.file("extdata", "HG-U95Av2_probe_tab.gz", 
                          package="matchprobes")
outdir   <- tempdir()
me       <- "Wolfgang Huber <w.huber@dkfz.de>"
species  <- "Homo_sapiens"
makeProbePackage("HG-U95Av2",
                 datafile   = gzfile(filename, open="r"),
                 outdir     = outdir,
                 maintainer = me,
                 species    = species,
                 version    = "0.0.1", 
                 force      = TRUE)
dir(outdir)


