### Name: logic.bagging
### Title: Bagged Logic Regression
### Aliases: logic.bagging logic.bagging.default logic.bagging.formula
###   print.logicBagg
### Keywords: tree regression

### ** Examples
## Not run: 
##D  # Load data.
##D    data(data.logicfs)
##D    
##D    # For logic regression and hence logic.bagging, the variables must
##D    # be binary. data.logicfs, however, contains categorical data 
##D    # with realizations 1, 2 and 3. Such data can be transformed 
##D    # into binary data by
##D    bin.snps<-make.snp.dummy(data.logicfs)
##D    
##D    # To speed up the search for the best logic regression models
##D    # only a small number of iterations is used in simulated annealing.
##D    my.anneal<-logreg.anneal.control(start=2,end=-2,iter=10000)
##D    
##D    # Bagged logic regression is then performed by
##D    bagg.out<-logic.bagging(bin.snps,cl.logicfs,B=20,nleaves=10,
##D        rand=123,anneal.control=my.anneal)
##D    
##D    # The output of logic.bagging can be printed
##D    bagg.out
##D    
##D    # By default, also the importances of the interactions are 
##D    # computed
##D    bagg.out$vim
##D    
##D    # and can be plotted.
##D    plot(bagg.out)
##D    
##D    # The original variable names are displayed in
##D    plot(bagg.out,coded=FALSE)
##D    
##D    # New observations (here we assume that these observations are
##D    # in data.logicfs) are assigned to one of the classes by
##D    predict(bagg.out,data.logicfs)
## End(Not run)


