### Name: interpolateHelper
### Title: Quantile Adjustment interpolator
### Aliases: interpolateHelper
### Keywords: algebra

### ** Examples

y<-matrix(rnbinom(10000,size=2,mu=10),ncol=4)
d<-list(data=y,group=rep(1:2,each=2),lib.size=rep(c(1000,1010),2))
ps<-estimatePs(d$data[,1:2],d$data[,3:4],d$lib.size[1:2],d$lib.size[3:4],r=2)
N<-prod(d$lib.size)^(1/ncol(d$data))
perc<-pnbinom(d$data-1,size=2,mu=outer(ps$p,d$lib.size))+dnbinom(d$data,size=2,mu=outer(ps$p,d$lib.size))/2
pseudo<-interpolateHelper(outer(ps$p,rep(N,4)),perc,r=2,d$data)



