###################################################
### chunk number 1: 
###################################################
options(width=70, scipen=999)


###################################################
### chunk number 2: 
###################################################
library("dualKS")
data("dks")
pData(eset)


###################################################
### chunk number 3: 
###################################################
	tr <- dksTrain(eset, class=1, type="up")


###################################################
### chunk number 4: 
###################################################
	cl <- dksSelectGenes(tr, n=100)


###################################################
### chunk number 5: 
###################################################
	pr <- dksClassify(eset, cl)
	summary(pr, actual=pData(eset)[,1])
	show(pr)


###################################################
### chunk number 6:  eval=FALSE
###################################################
## plot(pr, actual=pData(eset)[,1])


###################################################
### chunk number 7: 
###################################################
plot(pr, actual=pData(eset)[,1])


###################################################
### chunk number 8: 
###################################################
	pr <- dksClassify(eset, cl, rescale=TRUE)
	summary(pr, actual=pData(eset)[,1])


###################################################
### chunk number 9:  eval=FALSE
###################################################
## 	plot(pr, actual=pData(eset)[,1])


###################################################
### chunk number 10: 
###################################################
	plot(pr, actual=pData(eset)[,1])


###################################################
### chunk number 11:  eval=FALSE
###################################################
## 
## sc <- KS(exprs(eset)[,1], cl@genes.up)
## plot(sc$runningSums[,1], type='l', ylab="KS sum", ylim=c(-1200,1200), col="red")
## par(new=TRUE)
## plot(sc$runningSums[,2], type='l', ylab="KS sum", ylim=c(-1200,1200), col="green")
## par(new=TRUE)
## plot(sc$runningSums[,3], type='l', ylab="KS sum", ylim=c(-1200,1200), col="blue")
## legend("topright", col=c("red", "green", "blue"), lwd=2, legend=colnames(sc$runningSums))


###################################################
### chunk number 12: 
###################################################
sc <- KS(exprs(eset)[,1], cl@genes.up)
plot(sc$runningSums[,1], type='l', ylab="KS sum", ylim=c(-1200,1200), col="red")
par(new=TRUE)
plot(sc$runningSums[,2], type='l', ylab="KS sum", ylim=c(-1200,1200), col="green")
par(new=TRUE)
plot(sc$runningSums[,3], type='l', ylab="KS sum", ylim=c(-1200,1200), col="blue")
legend("topright", col=c("red", "green", "blue"), lwd=2, legend=colnames(sc$runningSums))


###################################################
### chunk number 13:  eval=FALSE
###################################################
## tr <- dksTrain(exprs(eset), class=pData(eset)[,1], type="up", weights=TRUE)
## cl <- dksSelectGenes(tr, n=100)
## pr <- dksClassify(exprs(eset), cl)
## plot(pr, actual=pData(eset)[,1])


###################################################
### chunk number 14: 
###################################################
tr <- dksTrain(exprs(eset), class=pData(eset)[,1], type="up", weights=TRUE)
cl <- dksSelectGenes(tr, n=100)
pr <- dksClassify(exprs(eset), cl)
plot(pr, actual=pData(eset)[,1])


###################################################
### chunk number 15:  eval=FALSE
###################################################
## wt <- dksWeights(eset, class=1)


###################################################
### chunk number 16:  eval=FALSE
###################################################
## tr <- dksTrain(exprs(eset), class=1, weights=wt)


###################################################
### chunk number 17:  eval=FALSE
###################################################
## 
## ix.n <- which(pData(eset)[,1] == "normal")
## data <- exprs(eset)
## data.m <- apply(data[,ix.n], 1, mean, na.rm=TRUE)
## 


###################################################
### chunk number 18:  eval=FALSE
###################################################
## data <- data[,-ix.n]
## data.r <- sweep(data, 1, data.m, "/")


###################################################
### chunk number 19:  eval=FALSE
###################################################
## data.r <- log(data.r, 2)
## tr <- dksTrain(data.r, class=pData(eset)[-ix.n,1], type="both")
## cl <- dksSelectGenes(tr, n=100)
## pr <- dksClassify(data.r, cl)
## plot(pr, actual=pData(eset)[-ix.n,1])


###################################################
### chunk number 20: 
###################################################
ix.n <- which(pData(eset)[,1] == "normal")
data <- exprs(eset)
data.m <- apply(data[,ix.n], 1, mean, na.rm=TRUE)
data <- data[,-ix.n]
data.r <- sweep(data, 1, data.m, "/")
data.r <- log(data.r, 2)

tr <- dksTrain(data.r, class=pData(eset)[-ix.n,1], type="both")
cl <- dksSelectGenes(tr, n=100)
pr <- dksClassify(data.r, cl)
plot(pr, actual=pData(eset)[-ix.n,1])


###################################################
### chunk number 21: 
###################################################
summary(pr, actual=pData(eset)[-ix.n,1])
show(pr)


###################################################
### chunk number 22: 
###################################################
pvalue.f <- pv.f


###################################################
### chunk number 23: 
###################################################
pvalue.f <- dksPerm(eset, 1, type="both", samples=500)


###################################################
### chunk number 24: 
###################################################
pvalue.f(pr@predictedScore)


###################################################
### chunk number 25:  eval=FALSE
###################################################
## cls <- factor(sample(pData(eset)[,1], 300, replace=TRUE))
## sig.up <- sample(rownames(exprs(eset), 300))
## classifier <- dksCustomClass(upgenes=sig.up, upclass=cls)
## pr.cust <- dksClassify(eset, classifier)


###################################################
### chunk number 26: 
###################################################
results <- data.frame(pr@predictedClass, pr@scoreMatrix)
results


