### Name: summarizeChannels
### Title: Normalization and transformation of dual-channel data
### Aliases: summarizeChannels
### Keywords: manip

### ** Examples

 ## Not run: 
##D     datadir <- system.file("DualChannelScreen", package = "cellHTS")
##D     x <- readPlateData("Platelist.txt", "TwoColorData", path=datadir)
##D     x <- configure(x, "Plateconf.txt", "Screenlog.txt", "Description.txt", path=datadir)
##D     table(x$wellAnno)
##D 
##D     ## Define the controls for the different channels:
##D     negControls=vector("character", length=dim(x$xraw)[4])
##D 
##D     ## channel 1 - gene A
##D     ## case-insensitive and match the empty string at the beginning and end of a line (to distinguish between "geneA" and "geneAB", for example, although this is not a problem for the well annotation in this example)
##D 
##D     negControls[1]= "(?i)^geneA$"  
##D     ## channel 2 - gene A and geneB
##D     negControls[2]= "(?i)^geneA$|^geneB$" 
##D     posControls = vector("character", length=dim(x$xraw)[4])
##D     ## channel 1 - no controls
##D     ## channel 2 - geneC and geneD
##D     posControls[2]="(?i)^geneC$|^geneD$"
##D 
##D     writeReport(x, posControls=posControls, negControls=negControls)
##D     ## In this example, we first normalize each channel separately by plate median scaling. 
##D     ## Then, we define a low intensity threshold for the measurements in the constitutive channel R1, 
##D     ## which will be set to the 5
##D     x = summarizeChannels(x, fun = function(r1, r2, 
##D              thresh=quantile(r1, probs=0.05, na.rm=TRUE)) ifelse(r1>thresh, log2(r2/r1), as.numeric(NA)),
##D       adjustPlates="median") 
##D     ## Note that the plate median scaling is applied to each channel, prior to channel summarization.
##D     ## Define the controls for the normalized intensities (only one channel):
##D     negControls = vector("character", length=dim(x$xnorm)[4])
##D     ## For the single channel, the negative controls are geneA and geneB 
##D     negControls[1]= "(?i)^geneA$|^geneB$" 
##D     posControls = vector("character", length=dim(x$xnorm)[4])
##D     ## For the single channel, the negative controls are geneC and geneD 
##D     posControls[1]="(?i)^geneC$|^geneD$"
##D     writeReport(x, force=TRUE, plotPlateArgs=list(xrange=c(-3,3)), 
##D          posControls=posControls, negControls=negControls)
##D  
## End(Not run)



