### Name: getHomolog
### Title: Get homologs
### Aliases: getHomolog
### Keywords: methods

### ** Examples

if(interactive()){
from.mart <- useMart("ensembl","hsapiens_gene_ensembl")
to.mart <- useMart("ensembl","mmusculus_gene_ensembl")

#HUGO to Entrez Gene

homolog = getHomolog(id = 1:20, from.mart = from.mart, to.mart = to.mart, from.type = 'entrezgene', to.type = 'refseq_dna')
show(homolog)

#ensembl to ensembl

homolog = getHomolog( id = "ENSG00000072778", from.mart = from.mart, from.type = "ensembl_gene_id", to.type="ensembl_gene_id",to.mart=to.mart)
show(homolog)

#Affy to Affy

homolog = getHomolog( id = "1939_at", to.type = "affy_mouse430_2", from.type = "affy_hg_u95av2", from.mart = from.mart, to.mart=to.mart )
show(homolog)

#Ensembl to Affy

homolog = getHomolog( id = "ENSG00000072778", to.type = "affy_mouse430_2", from.type = "ensembl_gene_id", from.mart = from.mart, to.mart = to.mart )
show(homolog)

}



