###################################################
### chunk number 1: setup
###################################################
options(width=65)


###################################################
### chunk number 2: read
###################################################
library(VanillaICE)
pathToIlluminaData <- system.file("illumina", package="VanillaICE")
illuminaEx <- read.table(paste(pathToIlluminaData, "/illuminaEx.txt", sep=""), 
                         sep="\t", as.is=TRUE)


###################################################
### chunk number 3: coerceData.frame
###################################################
gt <- illuminaEx[, "S1135.GType", drop=FALSE]
gt[gt == "AA"] <- 1
gt[gt == "BB"] <- 3
gt[gt == "AB"] <- 2
gt[gt == "NC"] <- 4
gt <- as.matrix(as.integer(gt[[1]]))
logR <- as.matrix(as.numeric(illuminaEx[, "S1135.Log.R.Ratio"]))
colnames(gt) <- colnames(logR) <- "S1135"
rownames(logR) <- rownames(gt) <- illuminaEx[, "Name"]
fd <- new("AnnotatedDataFrame",
          data=data.frame(position=illuminaEx[, "Position"],
	  chromosome=integer2chromosome(illuminaEx[, "Chr"]),
	  stringsAsFactors=FALSE),
          varMetadata=data.frame(labelDescription=c("position", "chromosome")))
featureNames(fd) <- illuminaEx[, "Name"]
##callsConfidence <- ratioConfidence <- matrix(NA, nrow=nrow(ratio), ncol=ncol(ratio))
##rownames(callsConfidence) <- rownames(ratioConfidence) <- rownames(ratio)
##colnames(callsConfidence) <- colnames(ratioConfidence) <- colnames(ratio)
##snpset <- new("RatioSnpSet",
##              ratio=ratio,
##	      ratioConfidence=ratioConfidence,
##              calls=gt,
##	      callsConfidence=callsConfidence,
##              featureData=fd,
##	      
##              annotation="Illumina550k")  
snpset <- new("oligoSnpSet",
	      copyNumber=logR,
	      calls=gt,
	      phenoData=annotatedDataFrameFrom(logR, byrow=FALSE),
	      featureData=fd,
	      annotation="Illumina550k") ##no annotation package as yet
chrom <- chromosome2integer(fd$chromosome)
snpset <- snpset[order(chrom, fd$position), ]
stopifnot(validObject(snpset))


###################################################
### chunk number 4: 
###################################################
gp <- plotSnp(snpset)
gp$cex <- 3
gp$ylab <- "copy number ratio"
gp$abline <- TRUE; gp$abline.h <- c(0.5, 1, 3/2); gp$abline.col <- "grey20"
gp$abline.lty <- c(2, 1, 2)


###################################################
### chunk number 5: plotSnp eval=FALSE
###################################################
## print(gp)


###################################################
### chunk number 6: hmmParameters eval=FALSE
###################################################
## featureData(snpset)$arm <- getChromosomeArm(snpset)
## options <- new("HmmOptions", 
## 	      snpset=snpset, 
## 	      states=c("D", "N", "L", "A"),
##               copyNumber.location=c(1, 2, 2, 3),
## 	      probHomCall=c(0.99, 0.75, 0.99, 0.75))
## params <- new("HmmParameter",
## 	     states=states(options))
## emission(params) <- copyNumber.emission(options)
## genomicDistance(params) <- exp(-2*diff(position(snpset))/(100*1e6))
## transitionScale(params) <- scaleTransitionProbability(states(options))


###################################################
### chunk number 7: fit eval=FALSE
###################################################
## fit <- hmm(options, params)


###################################################
### chunk number 8:  eval=FALSE
###################################################
## gp <- plotSnp(options@snpset, fit)
## gp$add.cytoband <- FALSE
## gp$ylab <- "copy number ratio"
## gp$abline <- TRUE; gp$abline.h <- c(0.5, 1, 3/2); gp$abline.col <- "grey20"
## gp$col.predict[states(fit) == "N"] <- "grey30"
## gp$abline.lty <- c(2, 1, 2)
## gp$hmm.ycoords <- c(0.4, 0.45)
## gp$ylim <- c(0.2, 2)


###################################################
### chunk number 9: hmmPlot eval=FALSE
###################################################
## print(gp)
## legend(0, 0.35, title="predicted states", fill="grey30", legend="ratio is 1", bty="n")


###################################################
### chunk number 10: 
###################################################
toLatex(sessionInfo())


