library(Rintact)
library(ppiData)
library(ppiStats)
library(ScISI)

xml1 <- "../11283351/11283351_ito-2001-1_01.xml"
xml2 <- "../11283351/11283351_ito-2001-1_02.xml"
xml3 <- "../11283351/11283351_ito-2001-1_03.xml"

itoC1 <- psi25interaction(xml1)
cv1 <- sapply(itoC1[[1]]@interactions, function(x) x@confidenceValue)
index1 <- cv1 == "ito-core"
core1 <- itoC1[[1]]@interactions[index1]
coreBaits1 <- sapply(core1, function(x) x@bait)
corePrey1 <- sapply(core1, function(x) x@prey)
interactors1 <- itoC1[[1]]@interactors
rownames(interactors1) <- interactors1[,2]
coreBaitsLN1 <- interactors1[coreBaits1, "locusName"]
neededBaitsIndex1 <- which(is.na(coreBaitsLN1)==TRUE)
neededBaits1 <- names(neededBaitsIndex1)
coreBaitsLN1.1 <- interactors1[neededBaits1, "orfName"]
corePreyLN1 <- interactors1[corePrey1, "locusName"]
neededPreyIndex1 <- which(is.na(corePreyLN1)==TRUE)
neededPrey1 <- names(neededPreyIndex1)
corePreyLN1.1 <- interactors1[neededPrey1, "orfName"]


itoC2 <- psi25interaction(xml2)
cv2 <- sapply(itoC2[[1]]@interactions, function(x) x@confidenceValue)
index2 <- cv2 == "ito-core"
core2 <- itoC2[[1]]@interactions[index2]
interactors2 <- itoC2[[1]]@interactors
rownames(interactors2) <- interactors2[,2]
coreBaits2 <- sapply(core2, function(x) x@bait)
coreBaitsLN2 <- interactors2[coreBaits2, "locusName"]
neededBaitsIndex2 <- which(is.na(coreBaitsLN2)==TRUE)
neededBaits2 <- names(neededBaitsIndex2)
coreBaitsLN2.1 <- interactors2[neededBaits2, "orfName"]
corePrey2 <- sapply(core2, function(x) x@prey)
corePreyLN2 <- interactors2[corePrey2, "locusName"]
neededPreyIndex2 <- which(is.na(corePreyLN2)==TRUE)
neededPrey2 <- names(neededPreyIndex2)
corePreyLN2.1 <- interactors2[neededPrey2, "orfName"]

itoC3 <- psi25interaction(xml3)
cv3 <- sapply(itoC3[[1]]@interactions, function(x) x@confidenceValue)
index3 <- cv3 == "ito-core"
interactors3 <- itoC3[[1]]@interactors
rownames(interactors3) <- interactors3[,2]
core3 <- itoC3[[1]]@interactions[index3]
coreBaits3 <- sapply(core3, function(x) x@bait)
coreBaitsLN3 <- interactors3[coreBaits3, "locusName"]
neededBaitsIndex3 <- which(is.na(coreBaitsLN3)==TRUE)
neededBaits3 <- names(neededBaitsIndex3)
coreBaitsLN3.1 <- interactors3[neededBaits3, "orfName"]
corePrey3 <- sapply(core3, function(x) x@prey)
corePreyLN3 <- interactors3[corePrey3, "locusName"]
neededPreyIndex3 <- which(is.na(corePreyLN3)==TRUE)
neededPrey3 <- names(neededPreyIndex3)
corePreyLN3.1 <- interactors3[neededPrey3, "orfName"]

coreBaitsLN1[neededBaitsIndex1] <- coreBaitsLN1.1
corePreyLN1[neededPreyIndex1] <- corePreyLN1.1
coreBaitsLN2[neededBaitsIndex2] <- coreBaitsLN2.1
corePreyLN2[neededPreyIndex2] <- corePreyLN2.1
coreBaitsLN3[neededBaitsIndex3] <- coreBaitsLN3.1
corePreyLN3[neededPreyIndex3] <- corePreyLN3.1

snbInd1 <- which(is.na(coreBaitsLN1)==TRUE)
stillNeededBaits1 <- names(snbInd1)
snpInd1 <- which(is.na(corePreyLN1)==TRUE)
stillNeededPrey1 <- names(snpInd1)
snbInd2 <- which(is.na(coreBaitsLN2)==TRUE)
stillNeededBaits2 <- names(snbInd2)
snpInd2 <- which(is.na(corePreyLN2)==TRUE)
stillNeededPrey2 <- names(snpInd2)
snbInd3 <- which(is.na(coreBaitsLN3)==TRUE)
stillNeededBaits3 <- names(snbInd3)
snpInd3 <- which(is.na(corePreyLN3)==TRUE)
stillNeededPrey3 <- names(snpInd3)

##I am manually curating the rest:

snb1 <- c("YDL175C","YOL149W","YOR023C","YDR488C")
names(snb1) <- stillNeededBaits1
snp1 <- c("YOL149W","YDL224C","YOR284W","YDL118W",
          "YOL149W","YOL050C","YDR022C","YNL054W-B",
          "06139","YDL204W","YDL204W")
names(snp1) <- stillNeededPrey1
snb2 <- c("YOR155C","YOR171C","YOR180C")
names(snb2) <- stillNeededBaits2
snp2 <- c("YOL149W","YOR284W","YOR102W","YOR359W",
          "YOL149W","YOR174W","YDR162C","YDR233C",
          "YOR155C","YOL149W","YOR034C","YOL149W",
          "YPL178W","YDR261W-B ","YOR155C","YOR284W")
names(snp2) <- stillNeededPrey2
snb3 <- c("YOR264W","YOR284W","YOR353C","YOR380W",
          "YLR082C")
names(snb3) <- stillNeededBaits3
snp3 <- c("YDR261W-B","YOR284W","YDR233C","YOR380W",
          "YPL219W","YLR082C","YOR247W")
names(snp3) <- stillNeededPrey3

coreBaitsLN1[snbInd1] <- snb1
corePreyLN1[snpInd1] <- snp1
coreBaitsLN2[snbInd2] <- snb2
corePreyLN2[snpInd2] <- snp2
coreBaitsLN3[snbInd3] <- snb3
corePreyLN3[snpInd3] <- snp3

coreBaitsLN1["Q03707"]
coreBaitsLN1["Q03707"] <- "YML034W"


coreBaits <- c(coreBaitsLN1, coreBaitsLN2, coreBaitsLN3)
corePrey <- c(corePreyLN1, corePreyLN2, corePreyLN3)

icBPList <- split(corePrey, coreBaits)

#icMat <- list2Matrix(icBPList)

bpList2Matrix <- function(bp){

  stopifnot(names(bp) == unique(names(bp)))
  baits <- names(bp)
  prey <- unique(unlist(bp))
  prots <- union(baits,prey)

  bpMat <- matrix(0, nrow=length(prots), ncol=length(prots))
  rownames(bpMat) <- prots
  colnames(bpMat) <- prots
  for(i in 1:length(baits)){
    bpMat[baits[i], bp[[baits[i]]]] <- 1
  }

  return(bpMat)

}

icMat2 <- bpList2Matrix(icBPList)

ItoCore2001BPGraph <- as(icMat2, "graphNEL")
