### Name: rdapply
### Title: Applying over spaces
### Aliases: rdapply rdapply,RDApplyParams-method RDApplyParams-class
###   RDApplyParams applyFun applyFun,RDApplyParams-method applyFun<-
###   applyFun<-,RDApplyParams-method applyParams
###   applyParams,RDApplyParams-method applyParams<-
###   applyParams<-,RDApplyParams-method filterRules
###   filterRules,RDApplyParams-method filterRules<-
###   filterRules<-,RDApplyParams-method rangedData
###   rangedData,RDApplyParams-method rangedData<-
###   rangedData<-,RDApplyParams-method reducerFun
###   reducerFun,RDApplyParams-method reducerFun<-
###   reducerFun<-,RDApplyParams-method reducerParams
###   reducerParams,RDApplyParams-method reducerParams<-
###   reducerParams<-,RDApplyParams-method simplify
###   simplify,RDApplyParams-method simplify<-
###   simplify<-,RDApplyParams-method
### Keywords: classes methods

### ** Examples

  ranges <- IRanges(c(1,2,3),c(4,5,6))
  score <- c(2L, 0L, 1L)
  rd <- RangedData(ranges, score, splitter = c("chr1","chr2","chr1"))
  
  ## a single function
  countrows <- function(rd) nrow(rd)
  params <- RDApplyParams(rd, countrows)
  rdapply(params) # list(chr1 = 2L, chr2 = 1L)

  ## with a parameter
  params <- RDApplyParams(rd, function(rd, x) nrow(rd)*x, list(x = 2))
  rdapply(params) # list(chr1 = 4L, chr2 = 2L)

  ## add a filter
  cutoff <- 0
  rules <- FilterRules(filter = score > cutoff)
  params <- RDApplyParams(rd, countrows, filterRules = rules)
  rdapply(params) # list(chr1 = 2L, chr2 = 0L)
  rules <- FilterRules(list(fun = function(rd) rd[["score"]] < 2),
                       filter = score > cutoff)
  params <- RDApplyParams(rd, countrows, filterRules = rules)
  rdapply(params) # list(chr1 = 1L, chr2 = 0L)
  active(filterRules(params))["filter"] <- FALSE
  rdapply(params) # list(chr1 = 1L, chr2 = 1L)

  ## simplify
  params <- RDApplyParams(rd, countrows, simplify = TRUE)
  rdapply(params) # c(chr1 = 2L, chr2 = 1L)

  ## reducing
  params <- RDApplyParams(rd, countrows, reducerFun = unlist,
                          reducerParams = list(use.names = FALSE))
  rdapply(params) ## c(2L, 1L)



