### Name: IRanges-setops
### Title: Set operations on IRanges objects
### Aliases: IRanges-setops union,IRanges,IRanges-method
###   intersect,IRanges,IRanges-method setdiff,IRanges,IRanges-method
###   punion punion,IRanges,IRanges-method pintersect
###   pintersect,IRanges,IRanges-method psetdiff
###   psetdiff,IRanges,IRanges-method
### Keywords: utilities

### ** Examples

  x <- IRanges(c(1, 5, -2, 0, 14), c(10, 9, 3, 11, 17))
  y <- IRanges(c(14, 0, -5, 6, 18), c(20, 2, 2, 8, 20)) 

  ## Vector-wise operations:
  union(x, y)
  intersect(x, y)
  setdiff(x, y)
  setdiff(y, x)

  ## Element-wise (aka "parallel") operations:
  try(punion(x, y))
  punion(x[3:5], y[3:5])
  punion(x, y, fill.gap=TRUE)
  pintersect(x, y)
  psetdiff(y, x)
  try(psetdiff(x, y))
  start(x)[4] <- -99
  end(y)[4] <- 99
  psetdiff(x, y)



