### Name: check
### Title: Check consistency of data in pedigree
### Aliases: check check.Pedigree checkId
### Keywords: misc attribute

### ** Examples

  ## EXAMPLES BELLOW ARE ONLY FOR TESTING PURPOSES AND ARE NOT INTENDED
  ## FOR USERS, BUT IT CAN NOT DO ANY HARM.

  ## --- checkAttributes ---
  tmp <- generatePedigree(5)
  attr(tmp, "sorted") <- FALSE
  attr(tmp, "coded") <- FALSE
  GeneticsPed:::checkAttributes(tmp)
  try(GeneticsPed:::checkAttributes(tmp, sorted=TRUE, coded=TRUE))

  ## --- idClass ---
  tmp <- generatePedigree(5)
  tmp$id <- factor(tmp$id)
  class(tmp$id)
  class(tmp$father)
  try(GeneticsPed:::idClass(tmp))

  ## --- idIsNA ---
  tmp <- generatePedigree(2)
  tmp[1, 1] <- NA
  GeneticsPed:::idIsNA(tmp)

  ## --- idNotUnique ---
  tmp <- generatePedigree(2)
  tmp[2, 1] <- 1
  GeneticsPed:::idNotUnique(tmp)

  ## --- idEqualAscendant ---
  tmp <- generatePedigree(2)
  tmp[3, 2] <- tmp[3, 1]
  GeneticsPed:::idEqualAscendant(tmp)

  ## --- ascendantEqualAscendant ---
  tmp <- generatePedigree(2)
  tmp[3, 2] <- tmp[3, 3]
  GeneticsPed:::ascendantEqualAscendant(tmp)

  ## --- ascendantInAscendant ---
  tmp <- generatePedigree(2)
  tmp[3, 2] <- tmp[5, 3]
  GeneticsPed:::ascendantInAscendant(tmp)
  ## Example with multiple parents
  tmp <- data.frame(id=c("A", "B", "C", "D"),
                    father1=c("E", NA, "F", "H"),
                    father2=c("F", "E", "E", "I"),
                    mother=c("G", NA, "H", "E"))
  tmp <- Pedigree(tmp, ascendant=c("father1", "father2", "mother"),
                  ascendantSex=c(1, 1, 2),
                  ascendantLevel=c(1, 1, 1))
  GeneticsPed:::ascendantInAscendant(tmp)

  ## --- unusedLevels ---
  tmp <- generatePedigree(2, colClass="factor")
  tmp[3:4, 2] <- NA
  GeneticsPed:::unusedLevels(tmp)



