### Name: plot.LD
### Title: Textual and graphical display of linkage disequilibrium (LD)
###   objects
### Aliases: plot.LD plot LDView
### Keywords: misc

### ** Examples


# load the data
data(CAMP)

# compute pairwise LD
ld <- LD(CAMP)

print(ld)    # text display of LD coefficents and graphical display of LD estimates

LDView(t(ld@"R^2"), SNPloc=1:8, SNPnames=CAMP@markerInfo$Name)

## LDtable(ld) # graphical display of LD estimates
## LDtable(ld, which="D'", digits=2) # graphical display of D' only 

## plot(CAMP) # two panel display




