### Name: html
### Title: Generate summary table files for genotype objects
### Aliases: html html.LD html.markerSummary html.GeneticsBaseSummary txt
###   txt.default txt.LD txt.markerSummary txt.GeneticsBaseSummary
###   print.GeneticsBaseSummary latex latex.default latex.LD
###   latex.markerSummary latex.GeneticsBaseSummary
### Keywords: misc

### ** Examples

data(CAMP)

###
# Generate a plain text allele summary table
###
aS <- alleleSummary(CAMP)
# display inline
txt(aS, filename="")
# create CAMP_alleleSummary.txt
txt(aS, filename="CAMP.alleleSummary.html") 

###
# Generate an HTML genotype summary table
###
gS <- genotypeSummary(CAMP)
# display inline
html(gS, filename="")
# create CAMP_genotypeSummary.html
html(gS, filename="CAMP.genotypeSummary.html")

###
# Generate a LaTeX Linkage Disequilibrium table
###
ld <- LD(CAMP)
# display inline
latex(ld, filename="")
# create CAMP_LDSummary.html
latex(ld, filename="CAMP.LD.html")

###
# Generate a complete set of summary tables 
###
mS <- markerSummary(CAMP)
# Plain text format
txt(mS, filename="CAMP", sep="_")
# HTML format
html(mS, filename="CAMP", sep="_")
# LaTeX format
latex(mS, filename="CAMP", sep="_")




