### Name: homozygote
### Title: Flag observations with specific allele patterns
### Aliases: homozygote homozygote.geneSet heterozygote
###   heterozygote.geneSet carrier carrier.geneSet dominant
###   dominant.geneSet recessive recessive.geneSet
### Keywords: misc

### ** Examples


data(CAMP)
lCAMP <- CAMP[,1:10] # 10 observations

# see the genotypes
genotypes(lCAMP)

# which ones are homozygotes?
homozygote(lCAMP)

# which ones are carriers  for allele "2"?
carrier(lCAMP, allele.names="2")

# which markers are heterozygotes for marker m709
heterozygote(lCAMP, marker="m709")

# if '1' is dominant, which ones will show the
# '1' phenotype for marker m47?
dominant(lCAMP, allele.names="1", marker="m47")

# if '2' is recessive, which ones will show the
# '2' phenotype for marker m523?
recessive(lCAMP, allele.names="2", marker="p523")




