### Name: as.geneSet
### Title: Convert an existing object to a geneSet
### Aliases: as.geneSet as.geneSet.matrix as.geneSet.data.frame
### Keywords: manip

### ** Examples


## Create a test data set where there are several genotypes in columns
## of the form "A/T".
test1 <- data.frame(Tmt=sample(c("Control","Trt1","Trt2"),20, replace=TRUE),
                G1=sample(c("A/T","T/T","T/A",NA),20, replace=TRUE),
                N1=rnorm(20),
                I1=sample(1:100,20,replace=TRUE),
                G2=paste(sample(c("134","138","140","142","146"),20,
                                replace=TRUE),
                         sample(c("134","138","140","142","146"),20,
                                replace=TRUE),
                         sep=" / "),
                G3=sample(c("A /T","T /T","T /A"),20, replace=TRUE),
                comment=sample(c("Possible Bad Data/Lab Error",""),20,
                               rep=TRUE)
                )
test1

## now automatically convert genotype columns
geno1 <- as.geneSet(test1)
geno1




