### Name: cmp.cluster
### Title: cluster compounds using a descriptor database
### Aliases: cmp.cluster
### Keywords: utilities

### ** Examples

# load sample database from web
db <- cmp.parse("http://bioweb.ucr.edu/ChemMineV2/static/example_db.sdf")
# cluster it
clusters <- cmp.cluster(db, cutoff=0.65)
# cluster using multiple cutoffs
clusters <- cmp.cluster(db, cutoff=c(0.5, 0.85))
# or save the distance before clustering:
clusters <- cmp.cluster(db, cutoff=0.65, save.distances="distmat.rda")
# later, you can load the matrix and pass it to do clustering. Load will load
# the variable 'distmat' that contains the distance matrix
load("distmat.rda")
clusters <- cmp.cluster(db, cutoff=0.60, use.distances=distmat)



