read.rg                package:CALIB                R Documentation

_R_e_a_d _R_G_L_i_s_t__C_A_L_I_B _f_r_o_m _I_m_a_g_e _A_n_a_l_y_s_i_s _O_u_t_p_u_t _F_i_l_e_s

_D_e_s_c_r_i_p_t_i_o_n:

     Reads an RGList_CALIB from a series of microarray image analysis
     output files

_U_s_a_g_e:

     read.rg(files = NULL, source = "generic", path = NULL, ext = NULL, 
             names = NULL, columns = NULL, other.columns = NULL,
             annotation = NULL,wt.fun = NULL, verbose = TRUE, sep = "\t",
             quote = NULL, DEBUG = FALSE, ...)

_A_r_g_u_m_e_n_t_s:

   files: character vector giving the names of the files containing
          image analysis output or, for Imagene data, a character
          matrix of names of files. If omitted, then all files with
          extension 'ext' in the specified directory will be read in
          alphabetical order.

  source: character string specifying the image analysis program which
          produced the output files.  Choices are '"generic"',
          '"agilent"', '"arrayvision"', '"bluefuse"', '"genepix"',
          '"genepix.custom"', '"genepix.median"',
           '"imagene"', '"quantarray"', '"scanarrayexpress"',
          '"smd.old"', '"smd"',
           '"spot"' or '"spot.close.open"'.

    path: character string giving the directory containing the files.
          The default is the current working directory.

     ext: character string giving optional extension to be added to
          each file name

   names: character vector of names to be associated with each array as
          column name. Defaults to 'removeExt(files)'.

 columns: list with fields 'R', 'G', 'Rb', 'Gb', 'RArea' and 'GArea'
          giving the column names to be used for red foreground, green
          foreground, red background, green background, red area and
          green area respectively. Or, in the case of Imagene data, a
          list with fields 'f' and 'b'. This argument is optional if
          'source' is specified, otherwise it is required.

other.columns: character vector of names of other columns to be read
          containing spot-specific information

annotation: character vector of names of columns containing annotation
          information about the probes

  wt.fun: function to calculate spot quality weights

 verbose: logical, 'TRUE' to report each time a file is read 

     sep: the field separator character 

   quote: character string of characters to be treated as quote marks 

   DEBUG: a logical value, if 'TRUE', a series of echo statements  will
          be printed for each file. Details on the file, skip,  and
          selected columns in a colClasses format for read.table  will
          be displayed.

     ...: any other arguments are passed to 'read.table'.

_D_e_t_a_i_l_s:

     This is the main data input function for CALIB package. It has the
     similar usage as the read.maimages function in limma package. The
     output of the  function is an 'RGList_CALIB' object. However,there
     are two more fields - '$RArea' and '$GArea' than 'RGList' object
     in limma package. These two fields contain spot area of each
     color. More details see 'read.maimages' in limma package.

_V_a_l_u_e:

     An 'RGList_CALIB' object containing the components

       R: matrix containing the red channel foreground intensities for
          each spot for each array.

       G: matrix containing the green channel foreground intensities
          for each spot for each array.

      Rb: matrix containing the red channel background intensities for
          each spot for each array.

      Gb: matrix containing the green channel background intensities
          for each spot for each array.

   RArea: matrix containing the red spot area for each spot for each
          array.

   GArea: matrix containing the green spot area for each spot for each
          array.

 weights: spot quality weights, if 'wt.fun' is given

   other: list containing matrices corresponding to 'other.columns' if
          given

   genes: data frame containing annotation information about the
          probes, for example gene names and IDs and spatial positions
          on the array, currently set only if 'source' is '"agilent"',
          '"genepix"' or 'source="imagene"' or if the 'annotation'
          argument is set

 targets: data frame with column 'FileName' giving the names of the
          files read

  source: character string giving the image analysis program name

 printer: list of class 'PrintLayout', currently set only if
          'source="imagene"'

_A_u_t_h_o_r(_s):

     Hui Zhao

_R_e_f_e_r_e_n_c_e_s:

     'read.maimages' in limma package

_S_e_e _A_l_s_o:

     'read.rg' is based on 'read.table' in the base package

_E_x_a_m_p_l_e_s:

      #  Read all .gpr files from current working directory.

      # files <- dir(pattern="*\.gpr$")
      # RG <- read.rg(files,"genepix")

