### Name: IPI-class
### Title: Class "IPI" a sub-class of pubRepo to handle data from
###   International Protein Index (IPI)
### Aliases: IPI-class parseData,IPI-method IPI
### Keywords: classes

### ** Examples

## Not run: 
##D ## create IPI class
##D ipi <- IPI(srcUrl="ftp://ftp.ebi.ac.uk/pub/databases/IPI/current/",
##D            organism = "human")
##D 
##D ## Parse ipi.HUMAN.dat.gz from IPI ftp site
##D tmpFile <- loadFromUrl(paste(srcUrls(ipi),baseFile(ipi)), sep="")
##D system("grep "//" ")
##D con <- file(tmpFile, "r")
##D 
##D tmpRead <- readLines(con, n=200)
##D endSymbol <- grep("//", tmpRead)
##D tmpRead <- tmpRead[1:endSymbol[length(endSymbol)]]
##D file <- tempfile()
##D writeLines(tmpRead, file)
##D 
##D system(paste("mv ", file, " ", tempdir(), "/ipi.tiny.dat", sep=""))
##D system(paste("gzip ", tempdir(), "/ipi.tiny.dat", sep=""))
##D ipiParser(ipiData=paste(tempdir(), "/ipi.tiny.dat.gz", sep=""), fromWeb=FALSE)
##D 
## End(Not run)



