### Name: runflowcytests
### Title: Tests the equivalence of two univariate sample distributions by
###   using four different methods
### Aliases: runflowcytests
### Keywords: univar dplot hplot

### ** Examples


if (require(rfcdmin)){
## obtaining the FCS objects from VRC data
if ( !(is.element("unst.1829", objects()) & is.element("st.1829",
objects()) & is.element("unst.DRT", objects()) & is.element("st.DRT",
objects())) ){
data(VRCmin)
}

## This only serves as an example.  Usually the FCS object is
## gated and then subset

## HIV negative individual 1829
  IFN.control<-unst.1829@data[1:2000,4]
  IFN.stimul<-st.1829@data[1:2000,4]

if (interactive()){

## running all the tests
output1.runall<-runflowcytests(IFN.control, IFN.stimul,
varname="Interferon Gamma",
title="HIV negative individual 1829", crit.pkci2=0.9999)
}

## HIV positive individual DRT
  IFN.control2<-unst.DRT@data[1:2000,4]
  IFN.stimul2<-st.DRT@data[1:2000,4]

if (interactive()){
## running only WLR.flowcytest and pkci2.flowcytest
output2.runall<-runflowcytests(IFN.control2, IFN.stimul2,
flowcytests=c("WLR","pkci2"), varname="Interferon Gamma",
title="HIV negative individual 1829", crit.pkci2=0.9999)
}
## This is an artifical example, but one would expect the
## distributions of the stimulated and control samples
## to be the same in the HIV negative individual 1829
## and to be different in the HIV positive individual DRT
## The test in this example is a bit contrived but
## the bigger picture is achieved.
}




