### Name: plotQA.FCS
### Title: Create a scatterplot summaryzing one (or two) parameter(s) for
###   several FCS objects stored in a plate
### Aliases: plotQA.FCS
### Keywords: hplot

### ** Examples

  ##Example I:
 data(flowcyt.data)

 ##Draw a scatterplot of the median values
 ##of the Foward scatter and the Side scatter parameters
 ##of each FCS file. The files correspond to samples store in a 96 well plate.
 plotQA.FCS(flowcyt.data,varpos=c(1,2),FUN1=median,nrow=8,ncol=10,ind=c(1:80),col="row",pch="*",labeling=FALSE,xlim=c(0,300),ylim=c(0,300),main="FSCmedian vs.SSCmedian by row",xlab="SSC median",ylab="FSC median")

 ##Example II:
 ##Draw a a scatterplot of the mode and IQR values for the Foward scatter
 ##of each FCS file. 
 plotQA.FCS(flowcyt.data,varpos=c(1),FUN1=IQR,FUN2=MODE,nrow=8,ncol=10,ind=c(1:80),col="col",pch="*",labeling=TRUE,xlim=c(0,300),ylim=c(0,300),xlab="FSC mode",ylab="FSC IQR",main="FSC IQR vs.FSC mode by column")
 


