###################################################
### chunk number 1: 
###################################################
library(lumi)


###################################################
### chunk number 2: 
###################################################
## load example data (a LumiBatch object)
data(example.lumi)
## summary of the example data
example.lumi


###################################################
### chunk number 3: 
###################################################
## summary of the quality control
summary(example.lumi, 'QC')


###################################################
### chunk number 4: 
###################################################
plot(example.lumi, what='density')	## plot the density


###################################################
### chunk number 5: 
###################################################
plot(example.lumi, what='boxplot') 	## box plot


###################################################
### chunk number 6: 
###################################################
plot(example.lumi, what='pair')		## pairwise plots


###################################################
### chunk number 7: 
###################################################
## pairwise MAplot
plot(example.lumi, what='MAplot')	


###################################################
### chunk number 8: 
###################################################
## density plot of coefficient of varience
plot(example.lumi, what='cv')	


###################################################
### chunk number 9: 
###################################################
plot(example.lumi, what='sampleRelation')


###################################################
### chunk number 10: 
###################################################
plot(example.lumi, what='sampleRelation', method='mds', color=c("01", "02", "01", "02"))


###################################################
### chunk number 11: 
###################################################
## Do default VST variance stabilizing transform
lumi.T <- lumiT(example.lumi)


###################################################
### chunk number 12: 
###################################################
trans <- plotVST(lumi.T)


###################################################
### chunk number 13: 
###################################################
matplot(log2(trans$untransformed), trans$transformed, type='l', main='compare VST and log2 transform', xlab='log2 transformed', ylab='vST transformed')
abline(a=0, b=1, col=2)


###################################################
### chunk number 14: 
###################################################
## Do quantile between microarray normaliazation
lumi.N <- lumiN(lumi.T)


###################################################
### chunk number 15: 
###################################################
## Do RSN between microarray normaliazation
# lumi.N <- lumiN(lumi.T, method='rsn')


###################################################
### chunk number 16: 
###################################################
## Do quality control estimation after normalization
lumi.N.Q <- lumiQ(lumi.N)

## summary of the quality control
summary(lumi.N.Q, 'QC')		## summary of QC


###################################################
### chunk number 17: 
###################################################
plot(lumi.N.Q, what='density')		## plot the density


###################################################
### chunk number 18: 
###################################################
plot(lumi.N.Q, what='boxplot')		## box plot
# boxplot(lumi.N.Q)


###################################################
### chunk number 19: 
###################################################
plot(lumi.N.Q, what='pair')			## pairwise plots


###################################################
### chunk number 20: 
###################################################
plot(lumi.N.Q, what='MAplot')		## plot the pairwise MAplot


###################################################
### chunk number 21: 
###################################################
## plot the sampleRelation using hierarchical clustering
plot(lumi.N.Q, what='sampleRelation')


###################################################
### chunk number 22: 
###################################################
## plot the sampleRelation using MDS
plot(lumi.N.Q, what='sampleRelation', method='mds', color=c("01", "02", "01", "02"))


###################################################
### chunk number 23: 
###################################################
## Do all the default preprocessing in one step
lumi.N.Q <- lumiExpresso(example.lumi)


###################################################
### chunk number 24: 
###################################################
## Do all the default preprocessing in one step
lumi.N.Q <- lumiExpresso(example.lumi, normalize.param=list(method='rsn'))


###################################################
### chunk number 25: 
###################################################
## Parameters of VST transformed LumiBatch object
names(attributes(lumi.T))
## VST parameters: "vstParameter"  and  "transformFun"
attr(lumi.T, 'vstParameter')
attr(lumi.T, 'transformFun')
## Parameters of VST transformed and RSN normalized LumiBatch object
names(attributes(lumi.N.Q))
## VSN "targetArray" , VST parameters: "vstParameter"  and  "transformFun"
attr(lumi.N.Q, 'vstParameter')
attr(lumi.N.Q, 'transformFun')
## After doing statistical analysis of the data, users can recover to the raw scale for the fold-change estimation.
## Inverse VST to the raw scale
lumi.N.raw <- inverseVST(lumi.N.Q)


###################################################
### chunk number 26: 
###################################################
dataMatrix <- exprs(lumi.N)


###################################################
### chunk number 27: 
###################################################
presentCount <- detectionCall(example.lumi)
selDataMatrix <- dataMatrix[presentCount > 0,]
selProbe <- rownames(selDataMatrix)


###################################################
### chunk number 28: 
###################################################
## Specify the sample type
sampleType <- c('100:0', '95:5', '100:0', '95:5')
if (require(limma)) {
	##  compare '95:5' and '100:0'
	design <- model.matrix(~ factor(sampleType))
	colnames(design) <- c('100:0', '95:5-100:0')
	fit <- lmFit(selDataMatrix, design)
	fit <- eBayes(fit)
	## Add gene symbols to gene properties
	if (require(lumiHumanAll.db) & require(annotate)) {
	    if (nrow(fit$genes) == 0) fit$genes <- data.frame(ID=rownames(selDataMatrix), stringsAsFactors=FALSE)
              geneSymbol <- getSYMBOL(fit$genes$ID, 'lumiHumanAll.db')
              fit$genes <- data.frame(fit$genes, geneSymbol=geneSymbol)
          }
	## print the top 10 genes
	print(topTable(fit, coef='95:5-100:0', adjust='fdr', number=10))
	
	## get significant gene list with FDR adjusted p.values less than 0.01
	p.adj <- p.adjust(fit$p.value[,2])		
	sigGene.adj <- selProbe[ p.adj < 0.01]
	## without FDR adjustment
	sigGene <- selProbe[ fit$p.value[,2] < 0.01]
} 


###################################################
### chunk number 29:  eval=FALSE
###################################################
## if (require(GOstats) & require(lumiHumanAll.db)) {
## 
## 	## Get the locuslink Id of the gene
## 	sigLL <- unique(unlist(lookUp(sigGene,'lumiHumanAll.db','ENTREZID')))
## 	sigLL <- as.character(sigLL[!is.na(sigLL)])
## 	params <- new("GOHyperGParams",
##               geneIds= sigLL,
##               annotation="lumiHumanAll.db",
##               ontology="BP",
##               pvalueCutoff= 0.01,
##               conditional=FALSE,
##               testDirection="over")
##          
##          hgOver <- hyperGTest(params)
##          	
## 	## Get the p-values of the test
## 	gGhyp.pv <- pvalues(hgOver)
## 	
## 	## select the Go terms with p-value less than 0.001
## 	sigGO.ID <- names(gGhyp.pv[gGhyp.pv < 0.001])
## 	
## 	## Here only show the significant GO terms of BP (Molecular Function)
## 	## 	For other categories, just follow the same procedure.
## 	sigGO.Term <- getGOTerm(sigGO.ID)[["BP"]]
## }


###################################################
### chunk number 30:  eval=FALSE
###################################################
## if (require(GOstats) & require(lumiHumanAll.db) & require(xtable)) {
## 
## 	##get gene counts at each GO category
## 	gg.counts <- geneCounts(hgOver)[sigGO.ID]
## 	total.counts <- universeCounts(hgOver)[sigGO.ID]
## 
## 	ggt <- unlist(sigGO.Term)
## 	numCh <- nchar(ggt)
## 	ggt2 <- substr(ggt, 1, 17)
## 	ggt3 <- paste(ggt2, ifelse(numCh > 17, "...", ""), sep="")
## 	
## 	## output the significant GO categories as a table
## 	ggMat <- matrix(c(names(sigGO.Term), ggt3, signif(gGhyp.pv[sigGO.ID],5), gg.counts, total.counts),
##     		byrow=FALSE, nc=5, dimnames=list(1:length(sigGO.Term), c("GO ID",
##    		"Term", "p-value","Significant Genes No.", "Total Genes No.")))
## 	xtable.matrix(ggMat,
##   		caption="GO terms, p-values and counts.", label="ta:GOggterms")
## }


###################################################
### chunk number 31: sessionInfo
###################################################
toLatex(sessionInfo())


