### Name: hmm
### Title: Fits the hidden Markov model
### Aliases: hmm
### Keywords: models

### ** Examples

data(chromosome1)
chromosome1 <- chromosome1[1:500, ]
options <- new("HmmOptions",
               states=c("D", "N", "L", "A"),
               snpset=chromosome1,
               copyNumber.location=c(1, 2, 2, 3),
               probHomCall=c(0.99, 0.7, 0.99, 0.7))
validObject(options)
params <- new("HmmParameter", 
              states=states(options),
              initialStateProbability=0.99)
cn.emission <- copyNumber.emission(options)
gt.emission <- calls.emission(options)
emission(params) <- cn.emission + gt.emission ##log scale
genomicDistance(params) <- exp(-2 * calculateDistance(options)/(100*1e6))
transitionScale(params) <- scaleTransitionProbability(options)
validObject(params)
fit <- hmm(options, params)



