### Name: Bscore
### Title: B score normalization
### Aliases: Bscore
### Keywords: manip

### ** Examples

    data(KcViabSmall)
    x <- KcViabSmall
    xb <- Bscore(x, save.model = TRUE)
    ## Calling Bscore function from "normalizePlates" and adding the per-plate variance adjustment step:
    xopt <- normalizePlates(x, method="Bscore", varianceAdjust="byPlate", save.model = TRUE)
    all(xb@rowcol.effects==xopt@rowcol.effects, na.rm=TRUE)
    all(xb@overall.effects==xopt@overall.effects, na.rm=TRUE)
    ## Access the slots overall.effects and rowcol.effects
    ef1 = plateEffects(xb)
    ef2 = plateEffects(xopt)
    identical(ef1, ef2)



