### Name: callEmission
### Title: Calculate emission probabilities for the ICE HMM
### Aliases: callEmission
### Keywords: manip

### ** Examples

  data(chromosome1)
  ##Create an object of class AnnotatedSnpCallSet
  callset <- new("AnnotatedSnpSet",
                 calls=calls(chromosome1),
                 callsConfidence=callsConfidence(chromosome1),
                 featureData=featureData(chromosome1),
                 phenoData=phenoData(chromosome1),
                 annotation=annotation(chromosome1))
  ##1 = homozygous (AA or BB), 2 = heterozygous
  calls(callset)[calls(callset) == 3] <-  1
  ##make sure that enzyme information is stored in featureData

## Not run: 
##D   require("callsConfidence")
##D     emissionProb <- callEmission(object=callset,
##D                                  P.CHOM.Normal=0.70,
##D                                  P.CHOM.LOH=0.999)
##D     range(emissionProb)
## End(Not run)



