### Name: plotgenes
### Title: Graph xy plot of variable (gene) projections from PCA or COA.
###   Only label variables at ends of axes
### Aliases: plotgenes
### Keywords: multivariate hplot

### ** Examples

data(khan)
if (require(ade4, quiet = TRUE)) {
khan.bga<-bga(khan$train, khan$train.classes) 
}
attach(khan.bga)
par(mfrow=c(2,2))
s.var(bet$ls, col=as.numeric(khan$train.classes), clabel=0.8)
plotgenes(bet$co, colpoints="red")
plotgenes(bet$co, colpoints="red", genelabels=khan$annotation$Symbol)
plotgenes(bet$co, colpoints="gray", genelabels=khan$annotation$Symbol,
boxes=FALSE)
s.groups(bet$ls, khan$train.classes, add.plot=TRUE,
col=c(1:length(levels(khan$train.classes))) )




