### Name: logic.fs
### Title: Feature Selection with Logic Regression
### Aliases: logic.fs
### Keywords: tree multivariate regression

### ** Examples
## Not run: 
##D    # Load data.
##D    data(data.logicfs)
##D    
##D    # For logic regression and hence logic.fs, the variables must
##D    # be binary. data.logicfs, however, contains categorical data 
##D    # with realizations 1, 2 and 3. Such data can be transformed 
##D    # into binary data by
##D    bin.snps<-make.snp.dummy(data.logicfs)
##D    
##D    # To speed up the search for the best logic regression models
##D    # only a small number of iterations is used in simulated annealing.
##D    my.anneal<-logreg.anneal.control(start=2,end=-2,iter=10000)
##D    
##D    # Feature selection using logic regression is then done by
##D    log.out<-logic.fs(bin.snps,cl.logicfs,B=20,nleaves=10,
##D        rand=123,anneal.control=my.anneal)
##D    
##D    # The output of logic.fs can be printed
##D    log.out
##D    
##D    # One can specify another number of interactions that should be
##D    # printed, here, e.g., 15.
##D    print(log.out,topX=15)
##D    
##D    # The variable importance can also be plotted.
##D    plot(log.out)
##D    
##D    # And the original variable names are displayed in
##D    plot(log.out,coded=FALSE)
## End(Not run)


