### Name: lattice-methods
### Title: Methods implementing Lattice displays for flow data
### Aliases: densityplot xyplot qqmath levelplot splom parallel
###   densityplot,formula,flowSet-method xyplot,formula,flowSet-method
###   qqmath,formula,flowSet-method levelplot,formula,flowSet-method
###   splom,flowFrame,missing-method parallel,flowFrame,missing-method
###   xyplot,flowFrame,missing-method xyplot,formula,flowFrame-method
### Keywords: methods dplot

### ** Examples


data(GvHD)
densityplot(factor(Visit) ~ `FSC-H` | factor(Patient), GvHD)

qqmath( ~ `FSC-H` | factor(Patient), GvHD,
       grid = TRUE, type = "l",
       f.value = ppoints(100))

phenoData(GvHD)$Patient <- factor(phenoData(GvHD)$Patient)
phenoData(GvHD)$Visit <- factor(phenoData(GvHD)$Visit)

## contourplot of bivariate density:

require(colorspace)
YlOrBr <- c("#FFFFD4", "#FED98E", "#FE9929", "#D95F0E", "#993404")
colori <- colorRampPalette(YlOrBr)
levelplot(`SSC-H` ~ `FSC-H` | Visit + Patient, GvHD, n = 20,
          col.regions = colori(50), main = "Contour Plot")


## simple bivariate scatter plot (a.k.a. dot plot)
## by default ('smooth=TRUE') panel.smoothScatter is used

xyplot(`SSC-H` ~ `FSC-H` | Patient:Visit, data = GvHD, 
       layout = c(7, 5))

xyplot(`SSC-H` ~ `FSC-H` | Patient:Visit,
       data = transform("SSC-H"=asinh,"FSC-H"=asinh) %on% GvHD,
       layout = c(7, 5))

## version without smooth

xyplot(`SSC-H` ~ `FSC-H` | Visit + Patient, data = GvHD, 
       smooth = FALSE, strip = strip.custom(strip.names = TRUE))

## several examples with time on the X axis

xyplot(`FSC-H` ~ Time | Visit, GvHD, 
       smooth = FALSE, type = "l", 
       subset = (Patient == 5))

xyplot(`FSC-H` ~ Time | Patient:Visit, GvHD, 
       smooth = FALSE, type = "l",
       strip = FALSE, strip.left = TRUE,
       aspect = "xy")

## combine plots for two channels

ssc.time <- 

    xyplot(`SSC-H` ~ Time | factor(Patient):factor(Visit), GvHD, 
           smooth = FALSE, type = "l",
           strip = FALSE,
           strip.left = strip.custom(horizontal = TRUE),
           par.strip.text = list(lines = 3),
           between = list(y = rep(c(0, 0.5), c(6, 1))),
           scales = list(x = list(axs = "i"), y = list(draw = FALSE)),
           layout = c(1, 35))

fsc.time <- 

    xyplot(`FSC-H` ~ Time | factor(Patient):factor(Visit), GvHD, 
           smooth = FALSE, type = "l",
           strip = FALSE,
           strip.left = strip.custom(horizontal = TRUE),
           par.strip.text = list(lines = 3),
           between = list(y = rep(c(0, 0.5), c(6, 1))),
           scales = list(x = list(axs = "i"), y = list(draw = FALSE)),
           layout = c(1, 35))

plot(fsc.time, split = c(1, 1, 2, 1))
plot(ssc.time, split = c(2, 1, 2, 1), newpage = FALSE)

## saving plots as variables allows more manipulation

plot(update(fsc.time[29:35], layout = c(1, 7)),
     split = c(1, 1, 1, 2))

plot(update(ssc.time[29:35], layout = c(1, 7)),
     split = c(1, 2, 1, 2), newpage = FALSE)

## scatter plot matrix of individual flowFrames

splom(GvHD[["s10a07"]], smooth = FALSE)

splom(GvHD[["s10a07"]], smooth = FALSE,
      prepanel.limits = function(x) quantile(as.numeric(x), c(0.0, 0.99)))

## parallel coordinate plots

parallel(GvHD[["s6a01"]])

## Not run: 
##D 
##D ## try with PDF device
##D parallel(GvHD[["s7a01"]], alpha = 0.01)
##D 
## End(Not run)

## time plot of individual flowFrames

xyplot(GvHD[["s5a07"]], time = "Time")

xyplot(`FSC-H` + `SSC-H` + `FL1-H` ~ Time, GvHD[["s5a07"]],
       aspect = "xy", outer = TRUE,
       scales = list(y = "free"),
       type = "l", smooth = FALSE)

xyplot(`FSC-H` ~ `SSC-H`, GvHD[["s5a01"]], nbin = 100)




