###Code to read the data into R

library(beadarray)
targets = readBeadSummaryTargets("targets.txt")

BSData <- readBeadSummaryData(targets)


##Example of how to read and subset the different slots available in BSData

exprs(BSData)[1:10,1:2]
se.exprs(BSData)[1:10, 1:2]
NoBeads(BSData)[1:10,1:2]
Detection(BSData)[1:10,1:2]
QCInfo(BSData)
pData(BSData)[,1:6]



##Simple boxplots of expression levels and number of each bead type

par(mfrow=c(1,2))
boxplot(log2(exprs(BSData)[1:1000,]),las=2)
boxplot(NoBeads(BSData)[1:1000,], las=2)


##Creating MA and XY plots to compare arrays

g = rownames(exprs(BSData))[1:10]
g
cols = rainbow(start=0, end=5/6, n=10)

plotMAXY(exprs(BSData)[1:1000,], arrays=1:3, genesToLabel=g, labelCols=cols)


par(mfrow=c(1,2))
plotXY(exprs(BSData), 1,2, sampleSize=10000)
plotMA(exprs(BSData), 1,2, sampleSize=10000)


##Illumina QC information may be read using readQC. Objects created by readBeadSummaryData should already have this infomation stored.

QC =readQC(targets[1,3])

QC$Signal[1:3,]

plotQC(BSData)

par(mfrow=c(1,3))
singleQCPlot(BSData, type="negative", main="Negative Control Signal", what="Signal")
singleQCPlot(BSData, type="negative", main="Negative Control Signal", what="StDev")


##Normalisation can be done using function from the affy library or the Illumina background normalisation can be done


BSData.quantile = assayDataElementReplace(BSData, "exprs",normalize.quantiles(as.matrix(exprs(BSData))))
BSData.qspline = assayDataElementReplace(BSData, "exprs", normalize.qspline(as.matrix(exprs(BSData))))
BSData.bgnorm = backgroundNormalise(BSData)


##For differential expression analysis, the functions from 'limma' can be used on log-transformed values

design=matrix(nrow=18, ncol=6,0)

colnames(design) = c("I", "MC", "MD", "MT", "P", "Norm")

design[which(strtrim(colnames(exprs(BSData)),1)=="I"),1]=1
design[which(strtrim(colnames(exprs(BSData)),2)=="MC"),2]=1
design[which(strtrim(colnames(exprs(BSData)),2)=="MD"),3]=1
design[which(strtrim(colnames(exprs(BSData)),2)=="MT"),4]=1
design[which(strtrim(colnames(exprs(BSData)),1)=="P"),5]=1
design[which(strtrim(colnames(exprs(BSData)),1)=="N"),6]=1

design

fit = lmFit(log2(exprs(BSData)), design)

cont.matrix=makeContrasts(IvsP = I - P, IvsNorm = I-Norm, PvsNorm = P-Norm,levels=design)

fit = contrasts.fit(fit, cont.matrix)

ebFit = eBayes(fit)

topTable(ebFit)

##Alternatively, the Illumina statistic is implemented as DiffScore


df = DiffScore(BSData,QC, cond=10, ref=1)

o=order(df, decreasing=TRUE)[1:50]
exprs(BSData)[o,10]/exprs(BSData)[o,1]


##Simple example of how a clustering can be performed

d =dist(t(exprs(BSData)))

plclust(hclust(d), labels=rownames(pData(BSData)))

