### Name: ps2ps
### Title: Find orthologous/homologous probe sets across two different
###   Affymetrix microarray formats using HomoloGene
### Aliases: ps2ps
### Keywords: manip

### ** Examples

## Not run: 
##D ##load Affymetrix annotations
##D annotMouse<-read.csv('Mouse430_2_annot.csv',colClasses='character')
##D annotHuman<-read.csv('HG-U133A_annot.csv',colClasses='character')
##D 
##D ##load HomoloGene database
##D homologene<-read.delim('homologene.data',header=FALSE)
##D 
##D ##define target species ID 
##D homoSapiens_ID<-9609
##D 
##D ##map all probe sets on mouse array Mouse 430 2.0 to their orthologs on human array HG-U133A
##D mappingTable<-ps2ps(annotMouse,annotHuman,homologene,targetSpecies)
##D 
##D ##write mapping table to disk
##D write.table(mappingTable,file='Mouse4302_HGU133A.txt',sep='\t',col.names=T,row.names=F,quote=FALSE)
##D 
##D ##to map the first 10 probe sets given in the annotation only
##D mappingTable<-ps2ps(annotMouse,annotHuman,homologene,targetSpecies,probesets=annotMouse[1:10,1])
## End(Not run)



