### Name: readCel2eSet
### Title: Read celfiles into an eSet object.
### Aliases: readCel2eSet
### Keywords: manip

### ** Examples

## To test the rotation, look at the scatterplot between two DNA hybes
## that were measured with scanner software that rotated (041120) and did
## not rotate (060125)
##
## cp /ebi/research/huber/Projects/tilingArray/Celfiles/041120_S96genDNA_re-hybe.cel.gz ~/p/tmp
## cp /ebi/research/huber/Projects/allelicTranscription/celfiles_allelictrans/060125_S96_genomicDNA.zip ~/p/tmp
## cd ~/p/tmp
## gunzip 041120_S96genDNA_re-hybe.cel.gz
## unzip 060125_S96_genomicDNA.zip
##
## Not run: 
##D library("affy")
##D library("geneplotter")
##D options(error=recover)
##D 
##D e1 = readCel2eSet("041120_S96genDNA_re-hybe.cel", rotated=TRUE)
##D e2 = readCel2eSet("060125_S96_genomicDNA.CEL")
##D 
##D smoothScatter(log(exprs(e1)), log(exprs(e2)), nrpoints=0)
## End(Not run)



