### Name: marrayRaw-class
### Title: Class "marrayRaw", classes and methods for pre-normalization
###   cDNA microarray intensity data
### Aliases: marrayRaw-class marrayRaw maRf maRf<- maGf maGf<- maRb maRb<-
###   maGb maGb<- maW maW<- maLayout maLayout<- [,marrayRaw-method
###   cbind,marrayRaw-method maA,marrayRaw-method
###   maControls<-,marrayRaw-method maControls,marrayRaw-method
###   maGb<-,marrayRaw,matrix-method maGb<-,marrayRaw,NULL-method
###   maGb,marrayRaw-method maGf<-,marrayRaw,matrix-method
###   maGf,marrayRaw-method maGnames,marrayRaw-method
###   maGridCol,marrayRaw-method maGridRow,marrayRaw-method
###   maLayout,marrayRaw-method maLG,marrayRaw-method maLR,marrayRaw-method
###   maM,marrayRaw-method maNgc<-,marrayRaw,numeric-method
###   maNgc,marrayRaw-method maNgr<-,marrayRaw,numeric-method
###   maNgr,marrayRaw-method maNotes<-,marrayRaw,character-method
###   maNotes,marrayRaw-method maNsamples,marrayRaw-method
###   maNsc<-,marrayRaw,numeric-method maNsc,marrayRaw-method
###   maNspots<-,marrayRaw,numeric-method maNspots,marrayRaw-method
###   maNsr<-,marrayRaw,numeric-method maNsr,marrayRaw-method
###   maPlate<-,marrayRaw-method maPlate,marrayRaw-method
###   maPrintTip,marrayRaw-method maRb<-,marrayRaw,matrix-method
###   maRb<-,marrayRaw,NULL-method maRb,marrayRaw-method
###   maRf<-,marrayRaw,matrix-method maRf,marrayRaw-method
###   maSpotCol,marrayRaw-method maSpotRow,marrayRaw-method
###   maSub<-,marrayRaw-method maSub,marrayRaw-method
###   maTargets,marrayRaw-method maW<-,marrayRaw,matrix-method
###   maW,marrayRaw-method print,marrayRaw-method show,marrayRaw-method
###   summary,marrayRaw-method maGnames maGnames<- maTargets maTargets<-
###   maLR maLG maNsamples
### Keywords: classes

### ** Examples

# Examples use swirl dataset, for description type ? swirl
require(limma)
data(swirl)

# Object of class marrayRaw for the 4 swirl arrays
swirl

# Object of class marrayLayout
maLayout(swirl)

# Access only the first 100 spots of the third array
swirl[1:100,3]

# Accessor methods -- How many spots on the array
maNspots(swirl)

# Density plot of log-ratios M for third array
plot(density(maM(swirl[,3])))

# Assignment methods -- Replace maNotes slot
maNotes(swirl)
maNotes(swirl)<-"This is a zebrafish microarray"
maNotes(swirl)

# Coerce methods -- Convert marrayRaw object into exprSet
## Load package convert
## library(convert)
## e<-as(swirl, "exprSet")
## e




