### Name: maNormMain
### Title: Main function for location and scale normalization of cDNA
###   microarray data
### Aliases: maNormMain
### Keywords: smooth methods

### ** Examples

# Examples use swirl dataset, for description type ? swirl
data(swirl)

# Within-print-tip-group loess location normalization of batch swirl
# - Default normalization
swirl.norm<-maNormMain(swirl)

boxplot(swirl.norm)
boxplot(swirl.norm[,3])
plot(swirl.norm[,3])

# Global median normalization for arrays 81 and 82
swirl.norm <- maNormMain(swirl[,1:2], f.loc = list(maNormMed(x=NULL,y="maM")))

# Global loess normalization for array 81
swirl.norm <- maNormMain(swirl[,1], f.loc = list(maNormLoess(x="maA",y="maM",z=NULL)))

# Composite normalization as in Yang et al. (2002)
# No MSP controls are available here, so all spots are used for illustration
# purposes
swirl.norm <- maNormMain(swirl[,1], f.loc = list(maNormLoess(x="maA",y="maM",z=NULL),maNormLoess(x="maA",y="maM",z="maPrintTip")), a.loc=maCompNormA())



