### Name: selectStatsBonferroni
### Title: Performs Bonferroni correction and subsequently selects relevant
###   annotation terms.
### Aliases: selectStatsBonferroni
### Keywords: utilities

### ** Examples


set.seed(1000)

data(benomylsetupsmall)

a <- new("goCluster")

execute(a) <- benomylsetupsmall

## The statistics are saved in the "statset" slot of
## the "stat" object that is itself a child of the "sign"
## object of a "goCluster" object
## We select all items with a p-value below 0.05 after
## Bonferroni correction. 
selectStatsBonferroni(a@sign@stat@statset,0.05,length(unlist(a@sign@stat@statset)))




