### Name: goCluster FDR analysis
### Title: Select interesting annotation terms after FDR analysis
### Aliases: randomizeTree mergeAnno selectAnnoStats
### Keywords: utilities

### ** Examples


set.seed(1000)

## Loading the reduced dataset with 100 genes
data(benomylsetupsmall)

a <- new("goCluster")

execute(a) <- benomylsetupsmall

## This demonstrates the use of "selectAnnoStats"
a@sign@statset[[1]][[1]]
selectAnnoStats(a@sign@statset, 0.1)[[1]][[1]]

## Randomizing the clustering result
randomGroups <- list()

for (i in 1:4) randomGroups[[i]] <- randomizeTree(a@algo@clusterset, 100)

## Four randomized datasets
randomGroups

## The clusters in the original dataset are being replaced
## by the randomized dataset. copyA now holds the randomized
## data together with the original annotation data which is
## necessary in order to perform the statistical analysis
copyA <- a
copyA@algo@clusterset <- randomGroups

## This executes the statistical function (a@sign@stat) on
## the randomized dataset (copyA) and assigns the
## result to the randomstat slot that is a specific
## slot for the FDR significance analysis
a@sign@stat <- reset(a@sign@stat)
a@sign@randomstat <- execute(a@sign@stat, copyA)@statset

randomStats <- list()

## This will merge the results for each of the three annotations
## and yields a distribution of p-values based on random gene
## selection
for (i in 1:3) randomStats[[i]] <- unlist(mergeAnno(a@sign@randomstat, i))

## This can be used to get information on the density
hist(randomStats[[1]],plot=FALSE,breaks=20)$density






