### Name: writeReport
### Title: Create a directory with HTML pages of linked tables and plots
###   documenting the contents of a cellHTS object
### Aliases: writeReport
### Keywords: manip

### ** Examples

 datadir = system.file("KcViabSmall", package = "cellHTS")
 x = readPlateData("Platelist.txt", "KcViabSmall", path=datadir)
 confFile = system.file("KcViabSmall", "Plateconf.txt", package="cellHTS")
 logFile  = system.file("KcViabSmall", "Screenlog.txt", package="cellHTS")
 descripFile  = system.file("KcViabSmall", "DESCRIPTION.txt", package="cellHTS")
 x = configure(x, confFile, logFile, descripFile)
 writeReport(x)
 x = normalizePlateMedian(x, zscore="-")
 x = summarizeReplicates(x, summary="min")
 writeReport(x, force=TRUE, plotPlateArgs = list(), imageScreenArgs=list(zrange=c(-4,4)))



