### Name: readCelRectangle
### Title: Reads a spatial subset of probe-level data from Affymetrix CEL
###   files
### Aliases: readCelRectangle
### Keywords: file IO

### ** Examples


for (zzz in 0) {

rotate270 <- function(x, ...) {
  x <- t(x)
  nc <- ncol(x)
  if (nc < 2) return(x)
  x[,nc:1,drop=FALSE]
}

# Scan current directory for CEL files
files <- list.files(pattern="[.](c|C)(e|E)(l|L)$")
files <- files[!file.info(files)$isdir]
if (length(files) == 0)
  break

celFile <- files[1];

# Read CEL intensities in the upper left corner
cel <- readCelRectangle(celFile, xrange=c(0,250), yrange=c(0,250))
z <- rotate270(cel$intensities)
sub <- paste("Chip type:", cel$header$chiptype)
image(z, col=gray.colors(256), axes=FALSE, main=celFile, sub=sub)
text(x=0, y=1, labels="(0,0)", adj=c(0,-0.7), cex=0.8, xpd=TRUE)
text(x=1, y=0, labels="(250,250)", adj=c(1,1.2), cex=0.8, xpd=TRUE)

# Clean up
rm(rotate270, files, celFile, cel, z, sub)

} # for (zzz in 0)



