### Name: facscan256.fcs
### Title: Flow Cytometry Standard (FCS) file version 2.0, University of
###   Washington, Seattle, WA
### Aliases: facscan256.fcs
### Keywords: datasets

### ** Examples

  if (require(rflowcyt)){

    ## the following current FCS R-objects are also produced
    ## by using 'data(*)'
    ## where * is one of the following example object names below
    ## * = facscan256.FCSRobj.current, facscan1024.FCSRobj.current, etc.

    location<-system.file("fcs", package="rfcdmin")

    facscan256.FCSRobj.current <- read.FCS(paste(location, "/facscan256.fcs", sep=""),
                                   fcs.type=fcs.type.facscan256)

 
  } else {
    cat("The rflowcyt package is required to run examples.\n\n")
  }



