### Name: PerPosROCmin
### Title: Vaccine Research Center (VRC), NIH, Bethesda, MD data-Percentage
###   Positives
### Aliases: PerPosROCmin PerPosROC hivpos.gag hivneg.gag hivpos.pola
###   hivneg.pola hivpos.polb hivneg.polb
### Keywords: datasets

### ** Examples

   data(PerPosROCmin)
if (require(rflowcyt)){
## the example below comes from ROC.FCS function

#plotting the gag stimulated 100* percent positives
   if (interactive()==TRUE){
      GAG<-ROC.FCS(hivpos.gag, hivneg.gag)
#plotting the pola stimulated 100* percent positives
      POLA<-ROC.FCS(hivpos.pola, hivneg.pola, lineopt=2, colopt=2, overlay=TRUE)
#plotting the polb stimulated 100* percent positives
      POLB<-ROC.FCS(hivpos.polb, hivneg.polb, lineopt=4, colopt=3, overlay=TRUE)
      legend(0.7, 0.7, c("gag", "polA", "polB"), col = c(1,2,3), lty=c(1,2,4))
    }
} else {
cat("Installation of the rflowcyt package is needed to run the examples.", "\n\n")
}




