### Name: plot.gff.toFile
### Title: Plots Formatted Tiling Array Data to a PNG or JPG File
### Aliases: plot.gff.toFile
### Keywords: hplot file

### ** Examples

   # getting data file name
   dataDir = system.file("extData", package = "gff3Plotter")
   gff3File = paste(dataDir, "test.gff3", sep = "/")

   # reading the input data file
   data = read.gff(gff3File)
   xrange = c(50000, 200000)
   coco.tresholds = 0.4
   names(coco.tresholds) = "Twist"
   expro.tresholds = c(0.2, 0.5, 0.1)
   names(expro.tresholds) = c("expDmf2", "expLmd", "expTwist")
   stages = c("stage13", "stage14", "stage15", "stage16")
   anatomy = "muscle"
   #plot.gff(data, xrange, coco.tresholds, expro.tresholds, stages, anatomy)
   plot.gff.toFile(data, "test.jpg", xrange = xrange, coco.tresholds = coco.tresholds, expro.tresholds = expro.tresholds, par.devstage = stages, par.anatomy = anatomy)



