### Name: subExprSet
### Title: A widget with menus that allow users to manipulate an experSet
###   object
### Aliases: subExprSet
### Keywords: interface

### ** Examples

    if(interactive()){
        require("Biobase") || stop("Biobase unavailable")
        require("gtkWidgets") || stop("gtkWidgets unavailable")
        data(geneData)
        data(geneCov)
        covdesc<- list("Covariate 1", "Covariate 2", "Covariate 3")
        names(covdesc) <- names(geneCov)
        pdata <- new("phenoData", pData=geneCov, varLabels=covdesc)
        eset <- new("exprSet", exprs=geneData, phenoData=pdata)

        # No argument passed. Use menu to import an exprSet object
        subExprSet()
    }



