\name{#PKGNAME#ALIAS}
\alias{#PKGNAME#ALIAS}
\title{An annotation data file that maps Open Reading Frame (ORF)
  identifiers to alias gene names}
\description{
  A set of gene names may have been used to report yeast genes
  represented by ORF ids. One such names has been used as the primary
  gene name and the rest are considered as alias names to the promary
  name. This data set maps ORF ids to alias gene names  
}
\details{
  This is an environment object containing key and value pairs. Keys are
  ORF ids and values are alias gene names. Values are vectors of length
  1 or more depending on whether an ORF id can be mapped to one or more
  alias names. ORF ids that can not be mapped to descriptive information
  are assigned a value NA.
  
  Annotation based on data provided by:

  #YGSOURCE#
  
  Package built: #DATE#
}
\references{
\url{http://www.yeastgenome.org/DownloadContents.shtml}
}
\examples{
	require("annotate") || stop("annotate unavailable")
	xx <- as.list(#PKGNAME#ALIAS)
	if(length(xx) > 0){
		# Get the value of the first key
		xx[[1]]
		# Get the values for a few keys
		if(length(xx) >= 3){
			xx[1:3]
		}
	}
}
\keyword{datasets}

